/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

public abstract class StaticProperty {
    public static final int DEPENDS_ON_CURRENT_ITEM = 1;
    public static final int DEPENDS_ON_CONTEXT_ITEM = 2;
    public static final int DEPENDS_ON_POSITION = 4;
    public static final int DEPENDS_ON_LAST = 8;
    public static final int DEPENDS_ON_CONTEXT_DOCUMENT = 16;
    public static final int DEPENDS_ON_CURRENT_GROUP = 32;
    public static final int DEPENDS_ON_REGEX_GROUP = 64;
    public static final int DEPENDS_ON_LOCAL_VARIABLES = 128;
    public static final int DEPENDS_ON_USER_FUNCTIONS = 256;
    public static final int DEPENDS_ON_XSLT_CONTEXT = 97;
    public static final int DEPENDS_ON_FOCUS = 30;
    public static final int DEPENDS_ON_NON_DOCUMENT_FOCUS = 14;
    public static final int ALLOWS_ZERO = 8192;
    public static final int ALLOWS_ONE = 16384;
    public static final int ALLOWS_MANY = 32768;
    public static final int CARDINALITY_MASK = 57344;
    public static final int ALLOWS_ONE_OR_MORE = 49152;
    public static final int ALLOWS_ZERO_OR_MORE = 57344;
    public static final int ALLOWS_ZERO_OR_ONE = 24576;
    public static final int EXACTLY_ONE = 16384;
    public static final int EMPTY = 8192;
    public static final int CONTEXT_DOCUMENT_NODESET = 65536;
    public static final int ORDERED_NODESET = 131072;
    public static final int REVERSE_DOCUMENT_ORDER = 262144;
    public static final int PEER_NODESET = 524288;
    public static final int SUBTREE_NODESET = 0x100000;
    public static final int ATTRIBUTE_NS_NODESET = 0x200000;
    public static final int NON_CREATIVE = 0x400000;
    public static final int SINGLE_DOCUMENT_NODESET = 0x800000;
    public static final int HAS_SIDE_EFFECTS = 0x1000000;
    public static final int DEPENDENCY_MASK = 0x10001FF;
    public static final int SPECIAL_PROPERTY_MASK = 0x1FF0000;

    public static int getCardinalityCode(int cardinality) {
        return (cardinality & 0xE000) >> 13;
    }

    public static String getCardinalityDescription(int cardinality) {
        int code = StaticProperty.getCardinalityCode(cardinality);
        String[] names = new String[]{"not allowed", "exactly zero", "exactly one", "zero or one", "many", "zero or many", "one or more", "zero or more"};
        return names[code];
    }

    private StaticProperty() {
    }
}

