/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.util.HashMap;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.instruct.UserFunction;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionBinder;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;

public class XQueryFunctionLibrary
implements FunctionLibrary,
XQueryFunctionBinder {
    private Configuration config;
    private HashMap functions = new HashMap(20);

    public XQueryFunctionLibrary(Configuration config) {
        this.config = config;
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void declareFunction(XQueryFunction function) throws XPathException {
        String keyObj = function.getIdentificationKey();
        XQueryFunction existing = (XQueryFunction)this.functions.get(keyObj);
        if (existing != null) {
            XPathException err = new XPathException("Duplicate definition of function " + function.getDisplayName() + " (see line " + existing.getLineNumber() + " in " + existing.getSystemId() + ')');
            err.setErrorCode("XQST0034");
            err.setIsStaticError(true);
            err.setLocator(function);
            throw err;
        }
        this.functions.put(keyObj, function);
    }

    public boolean isAvailable(StructuredQName functionName, int arity) {
        if (arity == -1) {
            for (int i = 0; i < 20; ++i) {
                if (!this.isAvailable(functionName, i)) continue;
                return true;
            }
            return false;
        }
        return this.functions.get(XQueryFunction.getIdentificationKey(functionName, arity)) != null;
    }

    public Expression bind(StructuredQName functionName, Expression[] arguments, StaticContext env) throws XPathException {
        String functionKey = XQueryFunction.getIdentificationKey(functionName, arguments.length);
        XQueryFunction fd = (XQueryFunction)this.functions.get(functionKey);
        if (fd != null) {
            UserFunctionCall ufc = new UserFunctionCall();
            ufc.setFunctionName(fd.getFunctionName());
            ufc.setArguments(arguments);
            ufc.setStaticType(fd.getResultType());
            UserFunction fn = fd.getUserFunction();
            if (fn == null) {
                fd.registerReference(ufc);
                ufc.setConfirmed(true);
            } else {
                ufc.setFunction(fn);
                ExpressionVisitor visitor = ExpressionVisitor.make(fd.getStaticContext());
                visitor.setExecutable(fd.getExecutable());
                ufc.checkFunctionCall(fn, visitor);
            }
            return ufc;
        }
        return null;
    }

    public XQueryFunction getDeclaration(StructuredQName functionName, Expression[] staticArgs) {
        String functionKey = XQueryFunction.getIdentificationKey(functionName, staticArgs.length);
        return (XQueryFunction)this.functions.get(functionKey);
    }

    public XQueryFunction getDeclarationByKey(String functionKey) {
        return (XQueryFunction)this.functions.get(functionKey);
    }

    public Iterator getFunctionDefinitions() {
        return this.functions.values().iterator();
    }

    protected void fixupGlobalFunctions(QueryModule env) throws XPathException {
        XQueryFunction fn;
        ExpressionVisitor visitor = ExpressionVisitor.make(env);
        Iterator iter = this.functions.values().iterator();
        while (iter.hasNext()) {
            fn = (XQueryFunction)iter.next();
            fn.compile();
        }
        iter = this.functions.values().iterator();
        while (iter.hasNext()) {
            fn = (XQueryFunction)iter.next();
            visitor.setExecutable(fn.getExecutable());
            fn.checkReferences(visitor);
        }
    }

    protected void optimizeGlobalFunctions() throws XPathException {
        Iterator iter = this.functions.values().iterator();
        while (iter.hasNext()) {
            XQueryFunction fn = (XQueryFunction)iter.next();
            fn.optimize();
        }
    }

    public void explainGlobalFunctions(ExpressionPresenter out) {
        Iterator iter = this.functions.values().iterator();
        while (iter.hasNext()) {
            XQueryFunction fn = (XQueryFunction)iter.next();
            fn.explain(out);
        }
    }

    public UserFunction getUserDefinedFunction(String uri, String localName, int arity) {
        String functionKey = XQueryFunction.getIdentificationKey(uri, localName, arity);
        XQueryFunction fd = (XQueryFunction)this.functions.get(functionKey);
        if (fd == null) {
            return null;
        }
        return fd.getUserFunction();
    }

    public FunctionLibrary copy() {
        XQueryFunctionLibrary qfl = new XQueryFunctionLibrary(this.config);
        qfl.functions = new HashMap(this.functions);
        return qfl;
    }
}

