<?xml version="1.0" encoding="utf-8"?>

<!-- 

This stylesheet preprocesses XML specifications
that contain included XML fragments,
merging in the included XML snippets to generate
the complete specification ready for rendering.

-->

<xsl:transform 
  xmlns:s="http://xbrl.org/specification/2007" 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
  xmlns:diff="http://xbrl.org/specification/2007/diff"
  version="2.0">

  <xsl:output 
    method="xml"
    encoding="utf-8"
    indent="yes"/>

  <!-- Mark changes added elements for all diff attributes -->
  <xsl:param name="mark-changes" select="0"/>
  <xsl:template match="*[@diff]">
    <xsl:choose>
      <xsl:when test="$mark-changes">
        <xsl:element name="diff:{@diff}">
          <xsl:copy>
            <xsl:apply-templates select="@*"/>
            <xsl:apply-templates select="comment() | text() | processing-instruction() | *"/>
          </xsl:copy>
        </xsl:element>
      </xsl:when>
      <xsl:otherwise>
        <xsl:copy>
          <xsl:apply-templates select="@*"/>
          <xsl:apply-templates select="comment() | text() | processing-instruction() | *"/>
        </xsl:copy>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="/ | *">
    <xsl:copy>
      <xsl:apply-templates select="@*"/>
      <xsl:apply-templates select="comment() | text() | processing-instruction() | *"/>
    </xsl:copy>
  </xsl:template>
    
  <xsl:template match="@* | text() | comment() | processing-instruction()">
    <xsl:copy/>
  </xsl:template>

  <xsl:template match="s:includeChunk | s:includePhrase">
    <xsl:apply-templates select="document(@ref,/.)/*"/>
  </xsl:template>

  <xsl:template match="s:container">
    <xsl:apply-templates/>
  </xsl:template>
   
</xsl:transform>

