<?xml version="1.0" encoding="UTF-8"?>
<!-- edited with XMLSPY v5 rel. 4 U (http://www.xmlspy.com) by Walter Hamscher (Standard Advantage) -->
<!-- XBRL 2.1 Tests -->
<!-- Copyright 2003 XBRL International. All Rights Reserved. -->
<xsl:stylesheet version="2.0" xmlns:v="http://xbrl.org/2007-08-14/versioning" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" exclude-result-prefixes="fo" xmlns:ver="http://xbrl.org/2007/versioning" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:template match="v:testcase">
		<html>
			<head>
				<title>
					<xsl:value-of select="@usecase"/>
				</title>
				<style type="text/css">
					body { font-family:Verdana,Arial,sans-serif; font-size:x-small }
					table { font-size:1em; border-collapse:collapse; }
					th { font-weight: normal;  padding: 0.8em; background-color: #FFFFBB; border: 1px solid gray;  font-weight:bold;}
					td { padding: 0.4em; }
					td.mapping {padding-top: 1.3em; }
					td.uri {border: 1px solid gray; background-color: #F0F8FF; }
					td.errorCode {border: 1px solid gray; background-color: #FF6666; }
					td.fromTo {border: 1px solid gray; background-color: #CCFFCC; }
					td.action {border: 1px solid gray; background-color: #99CCFF; }
					td.event {border: 1px solid gray; background-color: #FFCC66; }
					td.border {border: 1px solid gray; }
					td.borderIdent {border: 1px solid gray; }
					td.borderGray {border: 1px solid gray; background-color: #DCDCDC; }
					td.expandAction {border: 1px solid gray; background-color: #DCDCDC;  background-image:url(../expand.gif); background-repeat:no-repeat; background-position:6px 7px;}
					td.collapseAction {border: 1px solid gray; background-color: #DCDCDC;  background-image:url(../collapse.gif); background-repeat:no-repeat; background-position:6px 7px;}
					td.actionStart {border: 1px solid gray; background-color: #FFFFBB; }
					td.subheader { padding-top: 2em; }
					td.result { border: 1px solid gray; background-color: #FFFFBB; }
					span.headline {font-weight:bold; font-size:0.9em}
					a:link { color:#778899; text-decoration:none; }
					a:visited { color:#3366FF; text-decoration:none; }
					a:focus {color:#20B2AA; text-decoration:underline; }
					a:hover { color:#20B2AA; text-decoration:underline; }
					a:active { color:#778899; text-decoration:underline; }
			</style>
				<script type="text/javascript" src="../js/filter.js"/>
			</head>
			<body onLoad="init();">
				<form name="filterer">
					<table border="0" width="768px">
						<thead>
							<tr>
								<th colspan="2" align="left">
									<xsl:value-of select="@usecase"/>
								</th>
							</tr>
						</thead>
						<tbody>
							<tr>
								<td width="50%" class="borderGray">
									<xsl:text>Change Description</xsl:text>
								</td>
								<td class="border">
									<xsl:value-of select="v:description"/>
								</td>
							</tr>
							<xsl:if test="v:description/@reference">
								<tr>
									<td width="50%" class="borderGray">
										<xsl:text>Document reference</xsl:text>
									</td>
									<td class="border">
										<xsl:value-of select="v:description/@reference"/>
									</td>
								</tr>
							</xsl:if>
							<tr>
								<td class="borderGray">
									<xsl:text>Current Owner</xsl:text>
								</td>
								<td class="border">
									<xsl:element name="a">
										<xsl:attribute name="href">mailto:<xsl:value-of select="@email"/></xsl:attribute>
										<xsl:value-of select="@owner"/>
									</xsl:element>
								</td>
							</tr>
							<xsl:apply-templates select="v:vReport/v:version"/>
							<xsl:apply-templates select="v:vReport/v:assignment"/>
							<xsl:if test="v:vReport/v:action">
								<xsl:call-template name="orphanedActions"/>
							</xsl:if>
						</tbody>
						<tfoot/>
					</table>
					<div id="actions"/>
					<xsl:apply-templates select="v:vReport/v:action"/>
					<xsl:apply-templates select="v:result"/>
					<p style="margin-left:65%">
						<xsl:element name="a">
							<xsl:attribute name="href">../xvt.xml#<xsl:value-of select="@usecase"/></xsl:attribute>
							<xsl:text>back</xsl:text>
						</xsl:element>
					</p>
				</form>
			</body>
		</html>
	</xsl:template>
	<xsl:template name="orphanedActions">
		<tr>
			<td colspan="2" class="subheader">
				<span class="headline">
					<xsl:text>ORPHANED ACTIONS</xsl:text>
				</span>
			</td>
		</tr>
		<tr>
			<td colspan="2" class="borderGray">
				<span class="headline">
					<xsl:text>Referenced actions:</xsl:text>
				</span>
			</td>
		</tr>
		<xsl:for-each select=".//v:action">
			<xsl:if test="not(@id)">
				<tr>
					<xsl:element name="td">
						<xsl:attribute name="id"><xsl:value-of select="position()"/></xsl:attribute>
						<xsl:attribute name="colspan">2</xsl:attribute>
						<xsl:attribute name="class">expandAction</xsl:attribute>
						<xsl:element name="a">
							<xsl:attribute name="href"><xsl:text>#help</xsl:text><xsl:value-of select="position()"/></xsl:attribute>
							<xsl:element name="img">
								<xsl:attribute name="border">0</xsl:attribute>
								<xsl:attribute name="src">../pix.gif</xsl:attribute>
								<xsl:attribute name="width">12</xsl:attribute>
								<xsl:attribute name="height">12</xsl:attribute>
								<xsl:attribute name="alt">expand</xsl:attribute>
								<xsl:attribute name="onclick">changeImage(<xsl:value-of select="position()"/>)</xsl:attribute>
							</xsl:element>
						</xsl:element>
						<xsl:text>&#160;Action</xsl:text>
					</xsl:element>
				</tr>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="v:vReport/v:version">
		<tr>
			<td colspan="2" class="subheader">
				<span class="headline">
					<xsl:text>Comparision of the following taxonomy versions</xsl:text>
				</span>
			</td>
		</tr>
		<tr>
			<td class="borderGray">
				<xsl:text>From taxonomy</xsl:text>
			</td>
			<td class="borderGray">
				<xsl:text>To taxonomy</xsl:text>
			</td>
		</tr>
		<tr>
			<td class="border">
				<xsl:element name="a">
					<xsl:attribute name="href"><xsl:value-of select="v:fromURL"/></xsl:attribute>
					<xsl:value-of select="v:fromURL"/>
				</xsl:element>
			</td>
			<td class="border">
				<xsl:element name="a">
					<xsl:attribute name="href"><xsl:value-of select="v:toURL"/></xsl:attribute>
					<xsl:value-of select="v:toURL"/>
				</xsl:element>
			</td>
		</tr>
		<xsl:if test="v:nsMap">
			<tr>
				<td colspan="2" class="mapping">
					<span class="headline">
						<xsl:text>Namespace mapping</xsl:text>
					</span>
				</td>
			</tr>
			<tr>
				<td class="uri">
					<xsl:text>from URI</xsl:text>
				</td>
				<td class="uri">
					<xsl:text>to URI</xsl:text>
				</td>
			</tr>
			<xsl:apply-templates select="v:nsMap"/>
		</xsl:if>
		<xsl:if test="v:roleMap">
			<tr>
				<td colspan="2" class="mapping">
					<span class="headline">
						<xsl:text>Role mapping</xsl:text>
					</span>
				</td>
			</tr>
			<tr>
				<td class="uri">
					<xsl:text>from URI</xsl:text>
				</td>
				<td class="uri">
					<xsl:text>to URI</xsl:text>
				</td>
			</tr>
			<xsl:apply-templates select="v:roleMap"/>
		</xsl:if>
		<xsl:if test="v:conceptMap">
			<tr>
				<td colspan="2" class="mapping">
					<span class="headline">
						<xsl:text>Concept mapping</xsl:text>
					</span>
				</td>
			</tr>
			<tr>
				<td class="uri">
					<xsl:text>from concept</xsl:text>
				</td>
				<td class="uri">
					<xsl:text>to concept</xsl:text>
				</td>
			</tr>
			<xsl:apply-templates select="v:conceptMap"/>
		</xsl:if>
		<xsl:if test="v:resourceMap">
			<tr>
				<td colspan="2" class="mapping">
					<span class="headline">
						<xsl:text>Resource mapping</xsl:text>
					</span>
				</td>
			</tr>
			<tr>
				<td class="uri">
					<xsl:text>from Resource</xsl:text>
				</td>
				<td class="uri">
					<xsl:text>to Resource</xsl:text>
				</td>
			</tr>
			<xsl:apply-templates select="v:resourceMap"/>
		</xsl:if>
	</xsl:template>
	<xsl:template match="v:resourceMap|v:nsMap|v:roleMap|v:conceptMap">
		<tr>
			<td class="borderIdent">
				<xsl:value-of select="v:fromResource|v:fromURI|v:fromConcept"/>
			</td>
			<td class="borderIdent">
				<xsl:value-of select="v:toResource|v:toURI|v:toConcept"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="v:assignment">
		<tr>
			<td colspan="2" class="subheader">
				<span class="headline">
					<xsl:text>ASSIGNMENT</xsl:text>
				</span>
			</td>
		</tr>
		<xsl:apply-templates select="v:business|v:technical|v:errata"/>
		<tr>
			<td colspan="2" class="errorCode">
				<xsl:value-of select="v:text"/>
			</td>
		</tr>
		<xsl:if test="v:actionRef">
			<tr>
				<td colspan="2" class="borderGray">
					<span class="headline">
						<xsl:text>Referenced actions:</xsl:text>
					</span>
				</td>
			</tr>
			<xsl:apply-templates select="v:actionRef"/>
		</xsl:if>
	</xsl:template>
	<xsl:template match="v:business|v:technical|v:errata">
		<tr>
			<td colspan="2" class="errorCode">
				<span class="headline">
					<xsl:value-of select="local-name(.)"/>
				</span>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="v:actionRef">
		<tr>
			<xsl:element name="td">
				<xsl:attribute name="id"><xsl:value-of select="@ref"/></xsl:attribute>
				<xsl:attribute name="colspan">2</xsl:attribute>
				<xsl:attribute name="class">expandAction</xsl:attribute>
				<xsl:element name="a">
					<xsl:attribute name="href"><xsl:text>#help</xsl:text><xsl:value-of select="@ref"/></xsl:attribute>
					<xsl:element name="img">
						<xsl:attribute name="border">0</xsl:attribute>
						<xsl:attribute name="src">../pix.gif</xsl:attribute>
						<xsl:attribute name="width">12</xsl:attribute>
						<xsl:attribute name="height">12</xsl:attribute>
						<xsl:attribute name="onclick">changeImage('<xsl:value-of select="string(@ref)"/>')</xsl:attribute>
					</xsl:element>
				</xsl:element>
				<xsl:text>&#160;Action</xsl:text>
			</xsl:element>
		</tr>
	</xsl:template>
	<xsl:template match="v:action">
		<xsl:element name="div">
			<xsl:choose>
				<xsl:when test="@id">
					<xsl:attribute name="id"><xsl:text>help</xsl:text><xsl:value-of select="@id"/></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="id"><xsl:text>help</xsl:text><xsl:value-of select="position()"/></xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<table border="0" width="768px" bgcolor="white">
				<tr>
					<td class="action" width="50%">
						<span class="headline">
							<xsl:element name="a">
								<xsl:attribute name="name"><xsl:value-of select="@id"/></xsl:attribute>
								<xsl:text>ACTION</xsl:text>
							</xsl:element>
						</span>
					</td>
					<td class="action">
						<span class="headline">
							<xsl:value-of select="@id"/>
						</span>
					</td>
				</tr>
				<xsl:if test="ver:event">
					<tr>
						<td colspan="2" class="event">
							<span class="headline">
								<xsl:text>Event</xsl:text>
							</span>
						</td>
					</tr>
				</xsl:if>
				<xsl:apply-templates select="ver:event"/>
				<xsl:if test="v:text">
					<tr>
						<td colspan="2" class="border">
							<span class="headline">
								<xsl:text>Explanation: </xsl:text>
							</span>
							<xsl:value-of select="v:text"/>
						</td>
					</tr>
				</xsl:if>
			</table>
		</xsl:element>
	</xsl:template>
	<xsl:template match="v:result">
		<table border="0" width="768px">
			<tr>
				<td class="subheader" colspan="2">
					<span class="headline">
						<xsl:text>Result expected</xsl:text>
					</span>
				</td>
			</tr>
			<tr>
				<td class="result" colspan="2">
					<xsl:value-of select="."/>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template match="ver:event">
		<xsl:apply-templates select="ver:EvConceptNew|ver:EvConceptDelete|ver:EvConceptNamespace|ver:EvConceptName|ver:EvConceptType|ver:EvSubstitutionGroup|ver:EvPeriodType
															|ver:EvNillable|ver:EvAbstract|ver:EvBlock|ver:EvBalance|ver:EvDefault|ver:EvFixed|ver:EvFinal
															|ver:EvConceptRelationshipFrom|ver:EvConceptRelationshipTo|ver:EvConceptAttribute|ver:EvChild|ver:EvContent|ver:EvValue"/>
		<xsl:apply-templates select="ver:EvResourceNew|ver:EvResourceDelete|ver:EvResourceType|ver:EvRole|ver:EvResourceAttribute"/>
		<xsl:apply-templates select="ver:EvResourceTo|ver:EvResourceFrom"/>
	</xsl:template>
	<xsl:template match="ver:EvConceptNew|ver:EvConceptDelete|ver:EvConceptNamespace|ver:EvConceptName|ver:EvConceptType|ver:EvSubstitutionGroup|ver:EvPeriodType
											|ver:EvNillable|ver:EvAbstract|ver:EvBlock|ver:EvBalance|ver:EvDefault|ver:EvFixed|ver:EvFinal
											|ver:EvConceptRelationshipFrom|ver:EvConceptRelationshipTo|ver:EvConceptAttribute|ver:EvChild">
		<tr>
			<td colspan="2" class="actionStart" height="5">
			</td>
		</tr>
		<tr>
			<td colspan="2" class="borderGray">
				<span class="headline">
					<xsl:variable name="eventType" select="local-name(.)"/>
					<xsl:value-of select="$eventType"/>
				</span>
			</td>
		</tr>
		<tr>
			<td class="fromTo">
				<span class="headline">
					<xsl:text>From concept</xsl:text>
				</span>
			</td>
			<td class="fromTo">
				<span class="headline">
					<xsl:text>To concept</xsl:text>
				</span>
			</td>
		</tr>
		<tr>
			<xsl:choose>
				<xsl:when test="ver:fromConceptId or ver:fromId">
					<xsl:apply-templates select="ver:fromConceptId|ver:fromId"/>
				</xsl:when>
				<xsl:otherwise>
					<td class="border">
						<xsl:text>&#160;</xsl:text>
					</td>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="ver:toConceptId or ver:toId">
					<xsl:apply-templates select="ver:toConceptId|ver:toId"/>
				</xsl:when>
				<xsl:otherwise>
					<td class="border">
						<xsl:text>&#160;</xsl:text>
					</td>
				</xsl:otherwise>
			</xsl:choose>
		</tr>
		<xsl:apply-templates select="ver:EvTarget|ver:EvNext|ver:EvPriority|ver:EvSource|ver:EvRelationshipAttribute|ver:EvRelationshipNew|ver:EvRelationshipDelete|ver:EvPrevious"/>
		<xsl:apply-templates select="ver:EvNodeNew|ver:EvNodeDelete|ver:EvNodesInequality|ver:EvAttributeNew|ver:EvAttributeDelete|ver:EvAttributesInequality"/>
	</xsl:template>
	<xsl:template match="ver:EvResourceTo|ver:EvResourceFrom|ver:EvResourceAttribute|ver:EvContent">
		<tr>
			<td colspan="2" class="actionStart" height="5">
			</td>
		</tr>
		<tr>
			<td colspan="2" class="borderGray">
				<span class="headline">
					<xsl:variable name="eventType" select="local-name(.)"/>
					<xsl:value-of select="$eventType"/>
				</span>
			</td>
		</tr>
		<tr>
			<td class="fromTo">
				<span class="headline">
					<xsl:text>From resource</xsl:text>
				</span>
			</td>
			<td class="fromTo">
				<span class="headline">
					<xsl:text>To resource</xsl:text>
				</span>
			</td>
		</tr>
		<xsl:apply-templates select="ver:fromResourceId|ver:toResourceId"/>
		<xsl:apply-templates select="ver:EvTarget|ver:EvRelationshipNew|ver:EvNext|ver:EvPriority|ver:EvSource|ver:EvRelationshipAttribute|ver:EvRelationshipDelete|ver:EvPrevious|ver:EvAttributesInequality"/>
		<xsl:apply-templates select="ver:EvNodeNew|ver:EvNodeDelete|ver:EvNodesInequality"/>
	</xsl:template>
	<xsl:template match="ver:EvValue">
		<tr>
			<td colspan="2" class="actionStart" height="5">
			</td>
		</tr>
		<tr>
			<td colspan="2" class="borderGray">
				<span class="headline">
					<xsl:variable name="eventType" select="local-name(.)"/>
					<xsl:value-of select="$eventType"/>
				</span>
			</td>
		</tr>
		<tr>
			<td class="fromTo">
				<span class="headline">
					<xsl:text>From resource</xsl:text>
				</span>
			</td>
			<td class="fromTo">
				<span class="headline">
					<xsl:text>To resource</xsl:text>
				</span>
			</td>
		</tr>
		<tr>
			<xsl:apply-templates select="ver:toResourceId|ver:toNodeId|ver:toAttributeId|ver:fromResourceId|ver:fromNodeId|ver:fromAttributeId">
				<xsl:with-param name="dts">equal</xsl:with-param>
			</xsl:apply-templates>
		</tr>
	</xsl:template>
	<xsl:template match="ver:fromConceptId|ver:toConceptId">
		<td class="border">
			<xsl:value-of select="@ver:concept"/>
		</td>
	</xsl:template>
	<xsl:template match="ver:conceptAsSourceId|ver:conceptAsTargetId">
		<td class="border" valign="top">
			<span class="headline">Concept:</span>
			<br/>
			<xsl:value-of select="@ver:concept"/>
		</td>
	</xsl:template>
	<xsl:template match="ver:attributeId">
		<tr>
			<td colspan="2" class="border" valign="top">
				<span class="headline">XPath: </span>
				<xsl:value-of select="@ver:attributeXPath"/>
				<br/>
				<span class="headline">Value: </span>
				<xsl:value-of select="@ver:value"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="ver:resourceAsSourceId|ver:resourceAsTargetId|ver:toResourceId|ver:fromResourceId">
		<xsl:param name="dts"/>
		<xsl:if test="$dts='to'">
			<td class="border">
				<xsl:text>&#160;</xsl:text>
			</td>
		</xsl:if>
		<td class="border" valign="top">
			<span class="headline">Resource:</span>
			<br/>
			<span>Reference:
					<i>
					<xsl:value-of select=".//@ver:resourceRef"/>
				</i>
			</span>
		</td>
		<xsl:if test="$dts='from'">
			<td class="border">
				<xsl:text>&#160;</xsl:text>
			</td>
		</xsl:if>
	</xsl:template>
	<xsl:template match="ver:EvTarget|ver:EvNext|ver:EvPriority|ver:EvSource|ver:EvRelationshipAttribute|ver:EvRelationshipNew|ver:EvRelationshipDelete|ver:EvPrevious">
		<tr>
			<td colspan="2" class="borderGray">
				<span class="headline">
					<xsl:value-of select="local-name(.)"/>
				</span>
				<br/>
				<span>Relationship type:
					<i>
						<xsl:value-of select=".//@ver:relationshipType"/>
					</i>
				</span>
				<br/>
				<span>Extended link role:
					<i>
						<xsl:value-of select=".//@ver:extendedLinkRole"/>
					</i>
				</span>
				<br/>
				<span>Arcrole:
					<i>
						<xsl:value-of select=".//@ver:arcrole"/>
					</i>
				</span>
			</td>
		</tr>
		<xsl:apply-templates select="ver:fromRelationshipId|ver:toRelationshipId"/>
		<xsl:apply-templates select="ver:EvAttributeNew|ver:EvAttributeDelete|ver:EvAttributesInequality"/>
	</xsl:template>
	<xsl:template match="ver:toRelationshipId|ver:fromRelationshipId">
		<tr>
			<td colspan="2" class="fromTo">
				<span class="headline">
					<xsl:choose>
						<xsl:when test="contains(local-name(.), 'from')">
							<xsl:text>From</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>To</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</span>
			</td>
		</tr>
		<xsl:if test="ver:attributeId">
			<tr>
				<td colspan="2" class="borderGray">
					<xsl:text>Attribute(s)</xsl:text>
				</td>
			</tr>
			<xsl:apply-templates select="ver:attributeId"/>
		</xsl:if>
		<tr>
			<td class="borderGray">
				<xsl:text>Source</xsl:text>
			</td>
			<td class="borderGray">
				<xsl:text>Target</xsl:text>
			</td>
		</tr>
		<tr>
			<xsl:apply-templates select="ver:conceptAsSourceId"/>
			<xsl:apply-templates select="ver:resourceAsSourceId"/>
			<xsl:apply-templates select="ver:conceptAsTargetId"/>
			<xsl:apply-templates select="ver:resourceAsTargetId"/>
		</tr>
	</xsl:template>
	<xsl:template match="ver:EvResourceNew|ver:EvResourceDelete|ver:EvResourceType|ver:EvRole|ver:EvNodeNew|ver:EvNodeDelete|ver:EvNodesInequality|
											ver:EvAttributeNew|ver:EvAttributeDelete|ver:EvAttributesInequality">
		<tr>
			<td colspan="2" class="borderGray">
				<span class="headline">
					<xsl:value-of select="local-name(.)"/>
				</span>
			</td>
		</tr>
		<tr>
			<xsl:choose>
				<xsl:when test="contains(local-name(.), 'New')">
					<td colspan="2" class="fromTo">
						<span class="headline">
							<xsl:text>To</xsl:text>
						</span>
					</td>
				</xsl:when>
				<xsl:when test="contains(local-name(.), 'Delete')">
					<td colspan="2" class="fromTo">
						<span class="headline">
							<xsl:text>From</xsl:text>
						</span>
					</td>
				</xsl:when>
				<xsl:otherwise>
					<td class="fromTo">
						<span class="headline">
							<xsl:text>From</xsl:text>
						</span>
					</td>
					<td class="fromTo">
						<span class="headline">
							<xsl:text>To</xsl:text>
						</span>
					</td>
				</xsl:otherwise>
			</xsl:choose>
		</tr>
		<tr>
			<xsl:choose>
				<xsl:when test="not(contains(local-name(.), 'New') or contains(local-name(.), 'Delete') )">
					<xsl:apply-templates select="ver:toResourceId|ver:toNodeId|ver:toAttributeId|ver:fromResourceId|ver:fromNodeId|ver:fromAttributeId">
						<xsl:with-param name="dts">equal</xsl:with-param>
					</xsl:apply-templates>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates select="ver:toResourceId|ver:toNodeId|ver:toAttributeId">
						<xsl:with-param name="dts">to</xsl:with-param>
					</xsl:apply-templates>
					<xsl:apply-templates select="ver:fromResourceId|ver:fromNodeId|ver:fromAttributeId">
						<xsl:with-param name="dts">from</xsl:with-param>
					</xsl:apply-templates>
				</xsl:otherwise>
			</xsl:choose>
		</tr>
	</xsl:template>
	<xsl:template match="ver:toNodeId|ver:fromNodeId">
		<xsl:param name="dts"/>
		<xsl:if test="$dts='to'">
			<td class="border">
				<xsl:text>&#160;</xsl:text>
			</td>
		</xsl:if>
		<td class="border" valign="top">
			<span class="headline">Node:</span>
			<br/>
			<span>Node XPath:
					<i>
					<xsl:value-of select=".//@ver:nodeXPath"/>
				</i>
			</span>
		</td>
		<xsl:if test="$dts='from'">
			<td class="border">
				<xsl:text>&#160;</xsl:text>
			</td>
		</xsl:if>
	</xsl:template>
	<xsl:template match="ver:toAttributeId|ver:fromAttributeId">
		<xsl:param name="dts"/>
		<xsl:if test="$dts='to'">
			<td class="border">
				<xsl:text>&#160;</xsl:text>
			</td>
		</xsl:if>
		<td class="border" valign="top">
			<span class="headline">Attribute:</span>
			<br/>
			<span>Attribute XPath:
					<i>
					<xsl:value-of select=".//@ver:attributeXPath"/>
				</i>
			</span>
			<br/>
			<span>Value:
					<i>
					<xsl:value-of select=".//@ver:value"/>
				</i>
			</span>
		</td>
		<xsl:if test="$dts='from'">
			<td class="border">
				<xsl:text>&#160;</xsl:text>
			</td>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
