<!-- Copyright 2003 XBRL International. All Rights Reserved. -->
<xsl:stylesheet version="1.0" xmlns:v="http://xbrl.org/2007-08-14/versioning" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" exclude-result-prefixes="fo">
	<xsl:template match="testcases">
		<html>
			<head>
				<title>
					<xsl:value-of select="@name"/>
				</title>
				<style type="text/css">
					body { font-family:Verdana,Arial,sans-serif; font-size:x-small }
					h1 { font-size:1.3em }
					h2 { font-size:1.1em }
					#report { font-size:1em; border-collapse:collapse; }
					#usecase { font-size:1em; border-collapse:collapse; }
					#empty { font-size:1em; background-color:white;}
					#tdUsecase { font-size:1em; font-weight: normal; border-top: 1px solid gray;  border-left: 1px solid gray; border-right: 1px solid gray; padding: 0.4em; background-color: #FFFFBB; }
					#report  td   { border: 1px solid gray; padding: 0.4em; font-weight: normal;  }
					#report thead  { background-color: #DCDCDC; text-align: left; }
					th.head { border: 1px solid gray; padding: 0.4em; font-weight: normal;  }
					a:link { color:#778899; text-decoration:none; }
					a:visited { color:#87CEFA; text-decoration:none; }
					a:focus {color:#20B2AA; text-decoration:underline; }
					a:hover { color:#20B2AA; text-decoration:underline; }
					a:active { color:#778899; text-decoration:underline; }			
			</style>
			</head>
			<body>
				<h1>
					<xsl:value-of select="@name"/> dated <xsl:value-of select="@date"/>
				</h1>
				<h2>Overview of the test cases of the conformance suite</h2>
				<p/>
				<!-- now just generate one row per test set -->
				<xsl:apply-templates select="node()"/>
			</body>
		</html>
	</xsl:template>
	<xsl:template match="testcase">
		<xsl:variable name="uri" select="@uri"/>		
		<xsl:if test="substring-before(preceding-sibling::node()[1]/@uri, '/') != substring-before($uri, '/')">
		<p/>
		</xsl:if>
		<table border="0" width="90%"  id="report">			
			<thead>
				<xsl:variable name="usecase" select="document($uri)/v:testcase/@usecase"/>
				<xsl:if test="substring-before(preceding-sibling::node()[1]/@uri, '/') != substring-before($uri, '/')">
				<tr>
					<th width="20%" id="tdUsecase" colspan="2">						
						<xsl:element name="a">
							<xsl:attribute name="name"><xsl:value-of select="$usecase"/></xsl:attribute>
							<xsl:value-of select="$usecase"/>
						</xsl:element></th>
					<th id="empty" colspan="3">&#160;</th>
				</tr>
				<tr>
					<th class="head" width="20%">Previous</th>
					<th class="head" width="15%">Next</th>
					<th class="head" width="40%">Change Description</th>
					<th class="head" width="15%">Owner</th>
					<th class="head" width="10%">&#160;</th>
				</tr>
				</xsl:if>
			</thead>
			<tbody>
				<tr>
					<td width="20%" valign="top">
						<xsl:value-of select="document($uri)/v:testcase/v:vReport/v:version/v:fromURL"/>
					</td>
					<td width="15%" valign="top">
						<xsl:value-of select="document($uri)/v:testcase/v:vReport/v:version/v:toURL"/>
					</td>
					<td width="40%" valign="top">
						<xsl:variable name="description" select="document($uri)/v:testcase/v:description"/>
						<xsl:value-of select="$description"/>
					</td>
					<td width="15%" valign="top">
						<xsl:element name="a">
							<xsl:variable name="email" select="document($uri)/v:testcase/@email"/>
							<xsl:attribute name="href">mailto:<xsl:value-of select="$email"/></xsl:attribute>
							<xsl:value-of select="document($uri)/v:testcase/@owner"/>
						</xsl:element>
					</td>
					<td width="10%" nowrap="nowrap" valign="top">
						<xsl:element name="a">
							<xsl:attribute name="href"><xsl:value-of select="@uri"/></xsl:attribute>
							<xsl:text>more details</xsl:text>
						</xsl:element>
				</td>
				</tr>
			</tbody>
			<tfoot/>
		</table>
	</xsl:template>	
</xsl:stylesheet>
