/*
 * Decompiled with CFR 0.152.
 */
package com.simontuffs.onejar;

public final class Logger {
    public static final int LOGLEVEL_NONE = 0;
    public static final int LOGLEVEL_SEVERE = 1;
    public static final int LOGLEVEL_WARN = 2;
    public static final int LOGLEVEL_INFO = 3;
    public static final int LOGLEVEL_VERBOSE = 5;
    private static int loglevel = 3;
    private final String prefix;

    public static Logger getLogger(String name) {
        return new Logger(name);
    }

    private Logger(String name) {
        this.prefix = "[" + name + "] ";
    }

    public void severe(String message) {
        if (loglevel >= 1) {
            System.err.println(this.prefix + "ERROR: " + message);
        }
    }

    public void warning(String message) {
        if (loglevel >= 2) {
            System.err.println(this.prefix + "WARN:  " + message);
        }
    }

    public void info(String message) {
        if (loglevel >= 3) {
            System.out.println(this.prefix + "INFO:  " + message);
        }
    }

    public void fine(String message) {
        if (loglevel >= 5) {
            System.out.println(this.prefix + "FINE:  " + message);
        }
    }

    public static void setLevel(int level) {
        loglevel = level;
    }
}

